﻿//----------------------------------------------------------
// Copyright (C) Microsoft Corporation. All rights reserved.
//----------------------------------------------------------
/*global importScripts*/

var __extends = this.__extends || function (childCtor, parentCtor) {
    function __() { this.constructor = childCtor; }
    __.prototype = parentCtor.prototype;
    childCtor.prototype = new __();
    childCtor._base = parentCtor;
};

// ---- compatibility ------------------------------------------------------------
(function (global) {
    'use strict';

    var isIE8 = false;
    if (global.navigator) {
        isIE8 = global.navigator.userAgent.indexOf('MSIE 8') >= 0;
    }

    if (typeof Object.create !== 'function') {
        Object.create = function (o) {
            function F() { }
            F.prototype = o;
            return new F();
        };
    }
    if (isIE8 || typeof Object.defineProperty !== 'function') {
        Object.defineProperty = function (target, property, attributes) {
            target[property] = attributes.value;
        };
    }
    if (typeof Object.defineProperties !== 'function') {
        Object.defineProperties = function (target, properties) {
            for (var prop in properties) {
                if (properties.hasOwnProperty(prop)) {
                    target[prop] = properties[prop].value;
                }
            }
        };
    }
    if (typeof Object.keys !== 'function') {
        (function () {
            var localHasOwnProperty = Object.prototype.hasOwnProperty;
            Object.keys = function (o) {
                var result = [];
                for (var i in o) {
                    if (localHasOwnProperty.call(o, i)) {
                        result.push(i.toString());
                    }
                }
                return result;
            };
        })();
    }
    if (!Array.prototype.forEach) {
        Array.prototype.forEach = function (callbackfn, thisArg) {
            for (var i = 0, len = this.length; i < len; i++) {
                callbackfn.call(thisArg, this[i], i, this);
            }
        };
    }
    if (!Array.prototype.some) {
        Array.prototype.some = function (callbackfn, thisArg) {
            for (var i = 0, len = this.length; i < len; i++) {
                if (callbackfn.call(thisArg, this[i], i, this)) {
                    return true;
                }
            }
            return false;
        };
    }
    if (!Array.isArray) {
        Array.isArray = function (something) {
            return something ? something.constructor === Array : false;
        };
    }
    if (!String.prototype.trim) {
        String.prototype.trim = function () {

            var i, len, ch;

            var from = -1;
            for (i = 0, len = this.length; i < len; i++) {
                ch = this.charAt(i);
                if (ch !== ' ' && ch !== '\t' && ch !== '\n' && ch !== '\r') {
                    from = i;
                    break;
                }
            }

            if (from === -1) {
                return '';
            }

            var to;
            for (i = len - 1; i >= 0; i--) {
                ch = this.charAt(i);
                if (ch !== ' ' && ch !== '\t' && ch !== '\n' && ch !== '\r') {
                    to = i + 1;
                    break;
                }
            }

            return this.substring(from, to);
        };
    }
    if (!Array.prototype.map) {
        Array.prototype.map = function (callbackfn, thisArg) {
            var r = [];
            for (var i = 0, len = this.length; i < len; i++) {
                r[i] = callbackfn.call(thisArg, this[i], i, this);
            }
            return r;
        };
    }
    if (!Array.prototype.filter) {
        Array.prototype.filter = function (callbackfn, thisArg) {
            var r = [], v;
            for (var i = 0, len = this.length; i < len; i++) {
                v = this[i];
                if (callbackfn.call(thisArg, this[i], i, this)) {
                    r.push(v);
                }
            }
            return r;
        };
    }
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function (element, fromIndex) {
            fromIndex = fromIndex || 0;
            if (fromIndex >= this.length) {
                return -1;
            }
            for (var i = fromIndex, len = this.length; i < len; i++) {
                if (this[i] === element) {
                    return i;
                }
            }
            return -1;
        };
    }
    if (!Function.prototype.bind) {
        Function.prototype.bind = (function () {
            var slice = Array.prototype.slice;
            return function () {
                var originalFunc = this, thisArg = arguments[0], boundArgs = slice.call(arguments, 1);
                return function () {
                    return originalFunc.apply(thisArg, slice.call(boundArgs, 0).concat(slice.call(arguments, 0)));
                };
            };
        })();
    }
})(this);
// ---- end compatibility ------------------------------------------------------------

(function (global) {
    'use strict';

    if (typeof global.define === 'function' && global.define.amd) {
        //console.warn('Detected another loader, bailing out');
        return;
    }

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // utils

    var anonymousModuleGenerator = (function () {
        var id = 1;
        return function () {
            return '===anonymous' + (id++) + '===';
        };
    })();

    var isWebWorker = (typeof global.importScripts === 'function');

    if (!global.console) {
        global.console = {};
    }
    if (!global.console.log) {
        global.console.log = function () { };
    }

    // Capture console.log
    var consoleLog = Function.prototype.bind.call(global.console.log, global.console);

    // Function to invoke console.log
    var consoleLogInvoker = function () {
        consoleLog.apply(global.console, arguments);
    };

    if (!global.console.debug) {
        global.console.debug = consoleLogInvoker;
    }
    if (!global.console.info) {
        global.console.info = consoleLogInvoker;
    }
    if (!global.console.warn) {
        global.console.warn = consoleLogInvoker;
    }
    if (!global.console.error) {
        global.console.error = consoleLogInvoker;
    }

    function startsWith(haystack, needle) {
        return haystack.length >= needle.length && haystack.substr(0, needle.length) === needle;
    }

    function endsWith(haystack, needle) {
        return haystack.length >= needle.length && haystack.substr(haystack.length - needle.length) === needle;
    }


    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // Configuration

    function Configuration(options) {
        this.options = options || {};

		//alert(this.options.baseUrl);
		
        // baseUrl
        if (!this.options.baseUrl) {
            this.options.baseUrl = '';
        }

        if (this.options.baseUrl.length > 0) {
            if (!endsWith(this.options.baseUrl, '/')) {
                this.options.baseUrl += '/';
            }
        }

        // paths
        if (!this.options.paths) {
            this.options.paths = {};
        }

        // shim
        if (!this.options.shim) {
            this.options.shim = {};
        }

        // ignoreDuplicateModules
        if (!this.options.ignoreDuplicateModules) {
            this.options.ignoreDuplicateModules = [];
        }
        this.ignoreDuplicateModulesMap = {};
        for (var i = 0; i < this.options.ignoreDuplicateModules.length; i++) {
            this.ignoreDuplicateModulesMap[this.options.ignoreDuplicateModules[i]] = true;
        }
    }

    Configuration.prototype.getOptionsLiteral = function () {
        return this.options;
    };

    Configuration.prototype._applyPaths = function (module) {
        for (var path in this.options.paths) {
            if (this.options.paths.hasOwnProperty(path)) {
                if (startsWith(module, path)) {
                    return this.options.paths[path] + module.substr(path.length);
                }
            }
        }
        return module;
    };

    Configuration.prototype.moduleIdToPath = function (module) {
        if (endsWith(module, '.js')) {
            return module;
        }

        module = this._applyPaths(module) + (this.options.flavor || "") + '.js' + (this.options.pathSuffix || "");

        if (startsWith(module, 'http://') || startsWith(module, 'https://')) {
            return module;
        }

        return this.options.baseUrl + module;
    };

    Configuration.prototype.requireToUrl = function (url) {
        return this.options.baseUrl + this._applyPaths(url);
    };

    Configuration.prototype.isShimmed = function (moduleId) {
        return this.options.shim.hasOwnProperty(moduleId);
    };

    function recursiveClone(obj) {
        if (!obj || typeof obj !== 'object') {
            return obj;
        }
        var result = (obj instanceof Array) ? [] : {};
        var key, value;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                value = obj[key];
                if (value && typeof value === 'object') {
                    result[key] = recursiveClone(value);
                } else {
                    result[key] = value;
                }
            }
        }
        return result;
    }

    function simpleMixin(destination, source) {
        if (!source || typeof source !== 'object') {
            return destination;
        }
        for (var key in source) {
            if (source.hasOwnProperty(key)) {
                destination[key] = source[key];
            }
        }
        return destination;
    }

    Configuration.prototype.cloneAndMerge = function (options) {
        options = options || {};

        var resultOptions = recursiveClone(this.options);


        // baseUrl
        if (options.baseUrl === '' || options.baseUrl) {
            resultOptions.baseUrl = options.baseUrl;
        }

        if (options.flavor === '' || options.flavor) {
            resultOptions.flavor = options.flavor;
        }

        // additional parameters (like ?loc=)
        if (options.pathSuffix === '' || options.pathSuffix) {
            resultOptions.pathSuffix = options.pathSuffix;
        }

        // paths
        simpleMixin(resultOptions.paths, options.paths);

        // shim
        simpleMixin(resultOptions.shim, options.shim);

        // ignoreDuplicateModules
        if (options.ignoreDuplicateModules) {
            resultOptions.ignoreDuplicateModules.push.apply(resultOptions.ignoreDuplicateModules, options.ignoreDuplicateModules);
        }

        return new Configuration(resultOptions);
    };

    Configuration.prototype.getShimmedModuleDefine = function (moduleId) {
        var shimMD = this.options.shim[moduleId];
        if (!shimMD) {
            return null;
        }
        var result = {};
        if (shimMD instanceof Array) {
            result.dependencies = shimMD;
        } else {
            result.dependencies = shimMD.deps || [];
            if (shimMD.exports) {
                // TODO: Normalize testing of types into an util
                if (shimMD.exports instanceof Function) {
                    result.callback = shimMD.exports;
                } else if (shimMD.exports instanceof String) {
                    result.callback = function () {
                        return global[shimMD.exports];
                    };
                } else {
                    result.callback = {};
                }
            } else {
                result.callback = {};
            }
        }
        return result;
    };

    Configuration.prototype.isDuplicateMessageIgnoredFor = function (id) {
        return this.ignoreDuplicateModulesMap.hasOwnProperty(id);
    };

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ModuleIdResolver

    function ModuleIdResolver(config, fromModuleId) {
        this._config = config;
        this.fromModuleId = fromModuleId;
        this.fromModulePath = this._pathOf(this.fromModuleId);
    }

    ModuleIdResolver.prototype._pathOf = function (moduleId) {
        var lastSlash = moduleId.lastIndexOf('/');
        if (lastSlash !== -1) {
            return moduleId.substr(0, lastSlash + 1);
        } else {
            return '';
        }
    };

    ModuleIdResolver.prototype._normalizeModuleId = function (moduleId) {
        /// <summary>
        ///    Normalize 'a/../name' to 'name'
        /// </summary>

        // '/../xxxx' => '/xxxx' (can't go above root)
        while (startsWith(moduleId, '/../')) {
            moduleId = moduleId.substr(3);
        }

        var startsWithSlash = moduleId.length > 0 && moduleId.charAt(0) === '/';
        var parts = moduleId.split('/');
        for (var i = 0; i < parts.length; i++) {
            if (parts[i] === '.' || parts[i] === '') {
                parts.splice(i, 1);
                i--;
            } else {
                if (i > 0 && parts[i] === '..' && parts[i - 1] !== '..') {
                    parts.splice(i - 1, 2);
                    i -= 2;
                }
            }
        }
		return (startsWithSlash ? '/' : '') + parts.join('/');
    };

    ModuleIdResolver.prototype.resolveModule = function (moduleId) {
        var result = null;

        if (startsWith(moduleId, './') || startsWith(moduleId, '../')) {
            result = this.fromModulePath + moduleId;
        } else {
            result = moduleId;
        }

        return this._normalizeModuleId(result);
    };

    ModuleIdResolver.prototype.moduleIdToPath = function (moduleId) {
        return this._config.moduleIdToPath(moduleId);
    };

    ModuleIdResolver.prototype.requireToUrl = function (moduleId) {
        return this._config.requireToUrl(moduleId);
    };


    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // Module

    function Module(id, dependencies, callback, moduleIdResolver) {
        this._id = id;
        this._dependencies = dependencies;
        this._dependenciesValues = [];
        this._callback = callback;
        this._moduleIdResolver = moduleIdResolver;
        this._exports = {};
        this._exportsPassedIn = false;

        this._digestDependencies();

        if (this._unresolvedDependenciesCount === 0) {
            this._complete();
        }
    }

    Module.prototype._digestDependencies = function () {
        // Exact count of dependencies
        this._unresolvedDependenciesCount = this._dependencies.length;

        // Send on to the manager only a subset of dependencies
        // For example, 'exports' and 'module' can be fulfilled locally
        this._managerDependencies = [];
        this._managerDependenciesMap = {};

        var i, len, d;
        for (i = 0, len = this._dependencies.length; i < len; i++) {
            d = this._dependencies[i];

            if (d === 'exports') {
                // Fulfill 'exports' locally and remember that it was passed in
                // Later on, ee will ignore the return value of the factory
                this._exportsPassedIn = true;
                this._dependenciesValues[i] = this._exports;
                this._unresolvedDependenciesCount--;
            } else if (d === 'module') {
                // Fulfill 'module' locally
                this._dependenciesValues[i] = {
                    id: this._id
                };
                this._unresolvedDependenciesCount--;
            } else if (d === 'require') {
                // Request 'requre' from the manager
                this._managerDependencies.push(d);
                this._managerDependenciesMap[d] = i;
            } else {
                // Normalize dependency and then request it from the manager
                var bangIndex = d.indexOf('!');
                if (bangIndex >= 0) {
                    var pluginId = d.substring(0, bangIndex);
                    var pluginParam = d.substring(bangIndex + 1, d.length);
                    d = this._moduleIdResolver.resolveModule(pluginId) + '!' + pluginParam;
                } else {
                    d = this._moduleIdResolver.resolveModule(d);
                }
                this._managerDependencies.push(d);
                this._managerDependenciesMap[d] = i;
            }
        }
    };

    Module.prototype.renameDependency = function (oldDependencyId, newDependencyId) {
        /// <summary>
        ///   Called by the module manager because plugin dependencies can not
        ///   be normalized statically, the part after '!' can only be normalized
        ///   once the plugin has loaded and its normalize logic is plugged in.
        /// </summary>
        if (!this._managerDependenciesMap.hasOwnProperty(oldDependencyId)) {
            throw new Error('Loader: Cannot rename an unknown dependency!');
        }
        var index = this._managerDependenciesMap[oldDependencyId];
        delete this._managerDependenciesMap[oldDependencyId];
        this._managerDependenciesMap[newDependencyId] = index;
    };

    Module.prototype.getId = function () {
        return this._id;
    };

    Module.prototype.getModuleIdResolver = function () {
        return this._moduleIdResolver;
    };

    Module.prototype.isExportsPassedIn = function () {
        return this._exportsPassedIn;
    };

    Module.prototype.getExports = function () {
        return this._exports;
    };

    Module.prototype.getDependencies = function () {
        return this._managerDependencies;
    };

    Module.prototype._complete = function () {
        var error = null;
        if (this._callback) {
            if (typeof this._callback === 'function') {
                try {
                    var returnedExports = this._callback.apply(global, this._dependenciesValues);
                    if (!this._exportsPassedIn) {
                        this._exports = returnedExports;
                    }
                } catch (e) {
                    error = e;
                }
            } else {
                this._exports = this._callback;
            }
        }

        if (error) {
            console.error(error.stack);
            console.error(error);
        }
    };

    Module.prototype.resolveDependency = function (id, value) {
        if (this._managerDependenciesMap.hasOwnProperty(id)) {
            this._dependenciesValues[this._managerDependenciesMap[id]] = value;
            this._unresolvedDependenciesCount--;
            if (this._unresolvedDependenciesCount === 0) {
                this._complete();
            }
        } else {
            throw new Error('Cannot resolve a dependency I do not have!');
        }
    };

    Module.prototype.isComplete = function () {
        return this._unresolvedDependenciesCount === 0;
    };


    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ModuleManager

    function ModuleManager(scriptLoader) {
        this._defaultConfig = new Configuration();
        this._scriptLoader = scriptLoader;

        // Hash map of module id => module.
        // If a module is found in _modules, its code has been loaded, but
        // not necessary all its dependencies have been resolved
        this._modules = {};

        // Set of module ids => true
        // If a module is found in _knownModules, a call has been made
        // to the scriptLoader to load its code or a call will be made
        // This is mainly used as a flag to not try loading the same module twice
        this._knownModules = {};

        // Hash map of module id => array [module id]
        this._inverseDependencies = {};

        // Hash map of module id => array [module id]
        this._dependencies = {};

        // Hash map of module id => array [ { moduleId, pluginParam } ]
        this._inversePluginDependencies = {};

        // Count the number of define calls received
        this._queuedDefineCalls = [];

        // Count the number of scripts currently loading
        this._loadingScriptsCount = 0;
    }

    ModuleManager.prototype.enqueueDefineModule = function (id, dependencies, callback) {
        if (this._loadingScriptsCount === 0) {
            // There are no scripts currently loading, so no load event will be fired, so the queue will not be consumed
            this.defineModule(id, dependencies, callback);
        } else {
            this._queuedDefineCalls.push({
                id: id,
                dependencies: dependencies,
                callback: callback
            });
        }
    };

    ModuleManager.prototype.enqueueDefineAnonymousModule = function (dependencies, callback) {
        /// <summary>
        ///   Defines an anonymous module (without an id).
        ///   Its name will be resolved as we receive a callback from the scriptLoader
        /// </summary>
        /// <param name='dependencies' type='Array'>
        ///   See defineModule
        /// </param>
        /// <param name='callback' type='Any'>
        ///   See defineModule
        /// </param>
        this._queuedDefineCalls.push({
            id: null,
            dependencies: dependencies,
            callback: callback
        });
    };

    ModuleManager.prototype.defineModule = function (id, dependencies, callback, moduleIdResolver) {
        /// <summary>
        ///   Creates a module and stores it in _modules.
        ///   The manager will immediately begin resolving its dependencies.
        /// </summary>
        /// <param name="id" type="string">
        ///   An unique and absolute id of the module. This must not collide
        ///   with another module's id
        /// </param>
        /// <param name="dependencies" type="Array">
        ///   An array with the dependencies of the module. Special keys are:
        ///   "require", "exports" and "module"
        /// </param>
        /// <param name="callback" type="Any">
        ///   if callback is a function, it will be called with the resolved dependencies.
        ///   if callback is an object, it will be considered as the exports of the module. 
        /// </param>

        if (this._modules.hasOwnProperty(id)) {
            if (!this._defaultConfig.isDuplicateMessageIgnoredFor(id)) {
                console.warn('Duplicate definition of module \'' + id + '\'');
            }
            // super important! Ignore duplicate module definition
            return;
        }

        var module = new Module(id, dependencies, callback, (moduleIdResolver || new ModuleIdResolver(this._defaultConfig, id)));
        this._modules[id] = module;
		// alert(module);
		// for(var p in module)
		// {
			// alert(p);
		// }
        // TODO: If we must support unordered multiple define calls inside a file, then execute this in a timeout
        this._resolve(module);
    };

    ModuleManager.prototype._relativeRequire = function (moduleIdResolver, dependencies, callback) {
        if (typeof dependencies === 'string') {
            return this.synchronousRequire(dependencies, moduleIdResolver);
        }

        this.defineModule(anonymousModuleGenerator(), dependencies, callback, moduleIdResolver);
    };

    ModuleManager.prototype.synchronousRequire = function (id, moduleIdResolver) {
        /// <summary>
        ///   Require synchronously a module by its absolute id.
        ///   If the module is not loaded, an exception will be thrown.
        /// </summary>
        /// <param name="id" type="string">
        ///   The unique and absolute id of the required module
        /// </param>
        /// <returns type="Any">
        ///   The exports of module 'id'
        /// </returns>

        moduleIdResolver = (moduleIdResolver || new ModuleIdResolver(this._defaultConfig, id));
        var moduleId = moduleIdResolver.resolveModule(id);

        if (!this._modules.hasOwnProperty(moduleId)) {
            throw new Error('Check dependency list! Synchronous require cannot resolve module \'' + moduleId + '\'. This is the first mention of this module!');
        }
        var module = this._modules[moduleId];
        if (!module.isComplete()) {
            throw new Error('Check dependency list! Synchronous require cannot resolve module \'' + moduleId + '\'. This module has not been resolved completely yet.');
        }
        return module.getExports();
    };

    ModuleManager.prototype.setConfig = function (config) {
        this._defaultConfig = config;
    };

    ModuleManager.prototype.getConfig = function () {
        return this._defaultConfig;
    };

    ModuleManager.prototype._onLoad = function (id) {
        /// <summary>
        ///   Callback from the scriptLoader when a module has been loaded.
        ///   This means its code is available and has been executed.
        /// </summary>

        var defineCall;

        this._loadingScriptsCount--;

        if (this._defaultConfig.isShimmed(id)) {
            // Consume only named modules in the queue 
            while (this._queuedDefineCalls.length > 0) {
                if (this._queuedDefineCalls[0].id) {
                    defineCall = this._queuedDefineCalls.shift();
                    this.defineModule(defineCall.id, defineCall.dependencies, defineCall.callback);
                } else {
                    break;
                }
            }

            // If a shimmed module has loaded, create a define call for it
            defineCall = this._defaultConfig.getShimmedModuleDefine(id);
            this.defineModule(id, defineCall.dependencies, defineCall.callback);
        } else {
            if (this._queuedDefineCalls.length === 0) {
                console.warn('No define call received from module ' + id + '. This might be a problem.');
            } else {
                // Consume queue until first anonymous define call
                // or until current id is found in the queue
                while (this._queuedDefineCalls.length > 0) {
                    defineCall = this._queuedDefineCalls.shift();
                    if (defineCall.id === id || defineCall.id === null) {
                        // Hit an anonymous define call or its own define call
                        defineCall.id = id;
                        this.defineModule(defineCall.id, defineCall.dependencies, defineCall.callback);
                        break;
                    } else {
                        // Hit other named define calls
                        this.defineModule(defineCall.id, defineCall.dependencies, defineCall.callback);
                    }
                }
            }
        }

        if (this._loadingScriptsCount === 0) {
            // No more on loads will be triggered, so make sure queue is empty
            while (this._queuedDefineCalls.length > 0) {
                defineCall = this._queuedDefineCalls.shift();
                if (defineCall.id === null) {
                    console.error('Found an unmatched anonymous define call in the define queue. Ignoring it!');
                } else {
                    // Hit other named define calls
                    this.defineModule(defineCall.id, defineCall.dependencies, defineCall.callback);
                }
            }
        }
    };

    ModuleManager.prototype._onLoadError = function (id) {
        /// <summary>
        ///   Callback from the scriptLoader when a module hasn't been loaded.
        ///   This means that the script was not found (e.g. 404) or there was an error in the script.
        /// </summary>

        this._loadingScriptsCount--;
		
        console.error('Loading ' + id + ' failed, here are the modules that depend on it: ');
        console.error(this._inverseDependencies[id]);
    };

    ModuleManager.prototype._onModuleComplete = function (id, exports) {
        /// <summary>
        ///   Module id has been loaded completely, its exports are available.
        /// </summary>
        /// <param name="id" type="string">
        ///   Module's id
        /// </param>
        /// <param name="exports" type="Any">
        ///   Module's exports
        /// </param>
        var i, len, inverseDependencies, inverseDependencyId, inverseDependency;

        if (this._inverseDependencies.hasOwnProperty(id)) {
            // Fetch and clear inverse dependencies
            inverseDependencies = this._inverseDependencies[id];
            delete this._inverseDependencies[id];

            // Resolve one inverse dependency at a time, always
            // on the lookout for a completed module.
            for (i = 0, len = inverseDependencies.length; i < len; i++) {
                inverseDependencyId = inverseDependencies[i];
                inverseDependency = this._modules[inverseDependencyId];

                inverseDependency.resolveDependency(id, exports);
                if (inverseDependency.isComplete()) {
                    this._onModuleComplete(inverseDependencyId, inverseDependency.getExports());
                }
            }
        }

        if (this._inversePluginDependencies.hasOwnProperty(id)) {
            // This module is used as a plugin at least once
            // Fetch and clear these inverse plugin dependencies

            inverseDependencies = this._inversePluginDependencies[id];
            delete this._inversePluginDependencies[id];

            // Resolve plugin dependencies one at a time
            for (i = 0, len = inverseDependencies.length; i < len; i++) {
                this._resolvePluginDependencySync(inverseDependencies[i].moduleId, inverseDependencies[i].dependencyId, exports);
            }
        }
    };

    ModuleManager.prototype._hasDependencyPath = function (from, to) {
        /// <summary>
        ///   Walks (recursively) the dependencies of 'from' in search of 'to'.
        ///   Returns true if there is such a path or false otherwise.
        /// </summary>
        /// <param name="from" type="string">
        ///   Module id to start at
        /// </param>
        /// <param name="to" type="string">
        ///   Module id to look for
        /// </param> 
        var i, len, inQueue = {}, queue = [], element, dependencies, dependency;

        // Insert 'from' in queue
        queue.push(from);
        inQueue[from] = true;

        while (queue.length > 0) {
            // Pop first inserted element of queue
            element = queue.shift();

            if (this._dependencies.hasOwnProperty(element)) {
                dependencies = this._dependencies[element];

                // Walk the element's dependencies
                for (i = 0, len = dependencies.length; i < len; i++) {
                    dependency = dependencies[i];

                    if (dependency === to) {
                        // There is a path to 'to'
                        return true;
                    }

                    if (!inQueue.hasOwnProperty(dependency)) {
                        // Insert 'dependency' in queue
                        inQueue[dependency] = true;
                        queue.push(dependency);
                    }
                }
            }
        }

        // There is no path to 'to'
        return false;
    };

    ModuleManager.prototype._findCyclePath = function (from, to) {
        /// <summary>
        ///   Walks (recursively) the dependencies of 'from' in search of 'to'.
        ///   Returns cycle as array.
        /// </summary>
        /// <param name="from" type="string">
        ///   Module id to start at
        /// </param>
        /// <param name="to" type="string">
        ///   Module id to look for
        /// </param>
        if (from === to) {
            return [from];
        }
        if (!this._dependencies.hasOwnProperty(from)) {
            return null;
        }
        var path, dependencies = this._dependencies[from];

        // Walk the element's dependencies
        for (var i = 0, len = dependencies.length; i < len; i++) {
            path = this._findCyclePath(dependencies[i], to);
            if (path !== null) {
                path.push(from);
                return path;
            }
        }
        return null;
    };

    ModuleManager.prototype._createRequire = function (moduleIdResolver) {
        /// <summary>
        ///   Create the local 'require' that is passed into modules
        /// </summary>
        var result = this._relativeRequire.bind(this, moduleIdResolver);
        result.toUrl = function (id) {
            return moduleIdResolver.requireToUrl(moduleIdResolver.resolveModule(id));
        };
        return result;
    };

    ModuleManager.prototype._resolvePluginDependencySync = function (moduleId, dependencyId, plugin) {
        /// <summary>
        ///   Resolve a plugin dependency with the plugin loaded & complete
        /// </summary>
        /// <param name="moduleId" type="String">
        ///   The module that has this dependency
        /// </param>
        /// <param name="dependencyId" type="String">
        ///   The semi-normalized dependency that appears in the module
        ///   e.g. 'vs/css!./mycssfile'
        ///   Only the plugin part (before !) is normalized
        /// </param>
        /// <param name="plugin" type="Object">
        ///   The plugin (what the plugin exports)
        /// </param>
        var module = this._modules[moduleId];
        var moduleIdResolver = module.getModuleIdResolver();
        var bangIndex = dependencyId.indexOf('!');
        var pluginId = dependencyId.substring(0, bangIndex);
        var pluginParam = dependencyId.substring(bangIndex + 1, dependencyId.length);

        // Normalize the part which comes after '!'
        var normalize = function (_arg) {
            return moduleIdResolver.resolveModule(_arg);
        }.bind(this);

        if (typeof plugin.normalize === 'function') {
            pluginParam = plugin.normalize(pluginParam, normalize);
        } else {
            pluginParam = normalize(pluginParam);
        }

        // Now normalize the entire dependency
        var oldDependencyId = dependencyId;
        dependencyId = pluginId + '!' + pluginParam;

        // Let the module know that the dependency has been normalized
        // so it can update its internal state
        module.renameDependency(oldDependencyId, dependencyId);

        var loadCallback = function (moduleId) {
            // Delegate the loading of the resource to the plugin
            var parentRequire = this._createRequire(moduleIdResolver);
            var load = function (value) {
                this.defineModule(dependencyId, [], value);
            }.bind(this);

            load.error = function (error) {
                console.error('Loading ' + dependencyId + ' failed, here are the modules that depend on it: ');
                console.error(this._inverseDependencies[dependencyId]);
            }.bind(this);
            // TODO: pass here configuration to the plugin
            plugin.load(pluginParam, parentRequire, load, this._defaultConfig.getOptionsLiteral());
        }.bind(this);

        this._resolveDependency(moduleId, dependencyId, loadCallback);
    };

    ModuleManager.prototype._resolvePluginDependencyAsync = function (moduleId, dependencyId) {
        /// <summary>
        ///   Resolve a plugin dependency with the plugin not loaded or not complete yet
        /// </summary>
        /// <param name="moduleId" type="String">
        ///   The module that has this dependency
        /// </param>
        /// <param name="dependencyId" type="String">
        ///   The semi-normalized dependency that appears in the module
        ///   e.g. 'vs/css!./mycssfile'
        ///   Only the plugin part (before !) is normalized
        /// </param>
        var module = this._modules[moduleId];
        var bangIndex = dependencyId.indexOf('!');
        var pluginId = dependencyId.substring(0, bangIndex);

        // Record dependency for when the plugin gets loaded
        this._inversePluginDependencies[pluginId] = this._inversePluginDependencies[pluginId] || [];
        this._inversePluginDependencies[pluginId].push({
            moduleId: moduleId,
            dependencyId: dependencyId
        });

        if (!this._modules.hasOwnProperty(pluginId) && !this._knownModules.hasOwnProperty(pluginId)) {
            // This is the first mention of module 'pluginId', so load it
            this._knownModules[pluginId] = true;
            this._loadModule(module.getModuleIdResolver(), pluginId);
        }
    };

    ModuleManager.prototype._resolvePluginDependency = function (moduleId, dependencyId) {
        /// <summary>
        ///   Resolve a plugin dependency
        /// </summary>
        /// <param name="moduleId" type="String">
        ///   The module that has this dependency
        /// </param>
        /// <param name="dependencyId" type="String">
        ///   The semi-normalized dependency that appears in the module
        ///   e.g. 'vs/css!./mycssfile'
        ///   Only the plugin part (before !) is normalized
        /// </param>
        var bangIndex = dependencyId.indexOf('!');
        var pluginId = dependencyId.substring(0, bangIndex);

        if (this._modules.hasOwnProperty(pluginId) && this._modules[pluginId].isComplete()) {
            // Plugin has already been loaded & resolved
            this._resolvePluginDependencySync(moduleId, dependencyId, this._modules[pluginId].getExports());
        } else {
            // Plugin is not loaded or not resolved
            this._resolvePluginDependencyAsync(moduleId, dependencyId);
        }
    };

    ModuleManager.prototype._injectedShimModuleFactory = function (shimModuleId, loadCallback) {
        /// <summary>
        ///   For shim modules which have dependencies, a module is injected
        ///   to ensure that the dependencies get loaded before the actual
        ///   shim module gets loaded.
        ///   This is the factory/callback of such an injected module.
        /// </summary>
        loadCallback(shimModuleId);
    };

    ModuleManager.prototype._resolveShimmedDependency = function (moduleId, dependencyId, loadCallback) {
        /// <summary>
        ///   Resolve a module dependency to a shimmed module
        ///   and delegate the loading to loadCallback.
        /// </summary>
        /// <param name="moduleId" type="String">
        ///   The module that has this dependency
        /// </param>
        /// <param name="dependencyId" type="String">
        ///   The normalized dependency that appears in the module -- this module is shimmed
        /// </param>
        /// <param name="loadCallback" type="String">
        ///   Callback that will be called to trigger the loading of 'dependencyId' if needed
        /// </param>

        //   If a shimmed module has dependencies, we must first load those dependencies
        // and only when those are loaded we can load the shimmed module.
        //   To achieve this, we inject a module definition with those dependencies
        // and from its factory method we really load the shimmed module.
        var defineInfo = this._defaultConfig.getShimmedModuleDefine(dependencyId);
        if (defineInfo.dependencies.length > 0) {
            this.defineModule(
					anonymousModuleGenerator(),
					defineInfo.dependencies,
					this._injectedShimModuleFactory.bind(this, dependencyId, loadCallback),
					new ModuleIdResolver(this._defaultConfig, dependencyId)
			);
        } else {
            loadCallback(dependencyId);
        }
    };

    ModuleManager.prototype._resolveDependency = function (moduleId, dependencyId, loadCallback) {
        /// <summary>
        ///   Resolve a module dependency and delegate the loading to loadCallback
        /// </summary>
        /// <param name="moduleId" type="String">
        ///   The module that has this dependency
        /// </param>
        /// <param name="dependencyId" type="String">
        ///   The normalized dependency that appears in the module
        /// </param>
        /// <param name="loadCallback" type="String">
        ///   Callback that will be called to trigger the loading of 'dependencyId' if needed
        /// </param>
        var module = this._modules[moduleId];

        if (this._modules.hasOwnProperty(dependencyId) && this._modules[dependencyId].isComplete()) {
            // Dependency has already been loaded & resolved
            module.resolveDependency(dependencyId, this._modules[dependencyId].getExports());
        } else {
            // Dependency is not loaded or not resolved

            // Record dependency
            this._dependencies[moduleId].push(dependencyId);

            if (this._hasDependencyPath(dependencyId, moduleId)) {
                console.warn('There is a dependency cycle between \'' + dependencyId + '\' and \'' + moduleId + '\'. The cyclic path follows:');
                var cyclePath = this._findCyclePath(dependencyId, moduleId);
                cyclePath.reverse();
                cyclePath.push(dependencyId);
                console.warn(cyclePath.join(' => \n'));

                var dependency = this._modules.hasOwnProperty(dependencyId) ? this._modules[dependencyId] : null;
                var dependencyValue;
                if (dependency && dependency.isExportsPassedIn()) {
                    // If dependency uses 'exports', then resolve it with that object
                    dependencyValue = dependency.getExports();
                }
                // Resolve dependency with undefined or with 'exports' object
                module.resolveDependency(dependencyId, dependencyValue);
            } else {
                // Since we are actually waiting for this dependency,
                // record inverse dependency
                this._inverseDependencies[dependencyId] = this._inverseDependencies[dependencyId] || [];
                this._inverseDependencies[dependencyId].push(moduleId);

                if (!this._modules.hasOwnProperty(dependencyId) && !this._knownModules.hasOwnProperty(dependencyId)) {
                    // This is the first mention of module 'dependencyId', so load it
                    // Mark this module as loaded so we don't hit this case again
                    this._knownModules[dependencyId] = true;
                    if (this._defaultConfig.isShimmed(dependencyId)) {
                        this._resolveShimmedDependency(moduleId, dependencyId, loadCallback);
                    } else {
                        loadCallback(dependencyId);
                    }
                }
            }
        }
    };

    ModuleManager.prototype._loadModule = function (anyModuleIdResolver, moduleId) {
        this._loadingScriptsCount++;
        this._scriptLoader.load(anyModuleIdResolver.moduleIdToPath(moduleId), this._onLoad.bind(this, moduleId), this._onLoadError.bind(this, moduleId));
    };

    ModuleManager.prototype._resolve = function (module) {
        /// <summary>
        ///   Examine the dependencies of module 'module'
        ///   and resolve them as needed.
        /// </summary>
        var i, len, id, dependencies, dependencyId, moduleIdResolver;

        id = module.getId();
        dependencies = module.getDependencies();
        moduleIdResolver = module.getModuleIdResolver();

        this._dependencies[id] = [];

        for (i = 0, len = dependencies.length; i < len; i++) {
            dependencyId = dependencies[i];

            if (dependencyId === 'require') {
                module.resolveDependency(dependencyId, this._createRequire(moduleIdResolver));
                continue;
            } else {
                if (dependencyId.indexOf('!') >= 0) {
                    this._resolvePluginDependency(id, dependencyId);
                } else {
                    this._resolveDependency(id, dependencyId, this._loadModule.bind(this, moduleIdResolver));
                }
            }
        }

        if (module.isComplete()) {
            // This module was completed as soon as its been seen.
            this._onModuleComplete(id, module.getExports());
        }
    };



    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // BrowserScriptLoader

    function BrowserScriptLoader() {
    }

    BrowserScriptLoader.prototype.attachListeners = (function () {
        if (global.attachEvent) {
            return function (script, callback, errorback) {
                var loadEventListener = null, errorEventListener = null;

                var unbind = function () {
                    script.detachEvent('onreadystatechange', loadEventListener);
                    if (script.addEventListener) {
                        script.removeEventListener('error', errorEventListener);
                    }
                };

                loadEventListener = function (e) {
                    if (script.readyState === 'loaded' || script.readyState === 'complete') {
                        unbind();
                        callback();
                    }
                };

                errorEventListener = function (e) {
                    unbind();
                    errorback(e);
                };

                script.attachEvent('onreadystatechange', loadEventListener);
                if (script.addEventListener) {
                    script.addEventListener('error', errorEventListener);
                }
            };
        } else {
            return function (script, callback, errorback) {
                var loadEventListener = null, errorEventListener = null;

                var unbind = function () {
                    script.removeEventListener('load', loadEventListener);
                    script.removeEventListener('error', errorEventListener);
                };

                loadEventListener = function (e) {
                    unbind();
                    callback();
                };

                errorEventListener = function (e) {
                    unbind();
                    errorback(e);
                };

                script.addEventListener('load', loadEventListener);
                script.addEventListener('error', errorEventListener);
            };
        }
    })();

    BrowserScriptLoader.prototype.load = function (scriptSrc, callback, errorback) {
		scriptSrc = scriptSrc.substring(1);
        //alert(scriptSrc);
		var script = document.createElement('script');
        script.setAttribute('async', 'async');
        script.setAttribute('type', 'text/javascript');

        this.attachListeners(script, callback, errorback);

        script.setAttribute('src', scriptSrc);

        document.getElementsByTagName('head')[0].appendChild(script);
    };

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // WorkerScriptLoader

    function WorkerScriptLoader() {
        this.loadCalls = [];
        this.loadTimeout = -1;
    }

    WorkerScriptLoader.prototype.load = function (scriptSrc, callback, errorback) {
        this.loadCalls.push({
            scriptSrc: scriptSrc,
            callback: callback,
            errorback: errorback
        });

        if (navigator.userAgent.indexOf('Firefox') >= 0) {
            // Firefox fails installing the timer every now and then :(
            this._load();
        } else {
            if (this.loadTimeout === -1) {
                this.loadTimeout = setTimeout(this._load.bind(this), 0);
            }
        }
    };

    WorkerScriptLoader.prototype._load = function () {
        this.loadTimeout = -1;

        var loadCalls = this.loadCalls;
        this.loadCalls = [];

        var i, len = loadCalls.length, scripts = [];

        for (i = 0; i < len; i++) {
            scripts.push(loadCalls[i].scriptSrc);
        }

        try {
            importScripts.apply(null, scripts);

            for (i = 0; i < len; i++) {
                loadCalls[i].callback();
            }
        } catch (e) {
            for (i = 0; i < len; i++) {
                loadCalls[i].errorback(e);
            }
        }
    };

    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // define

    var scriptLoader = isWebWorker ? new WorkerScriptLoader() : new BrowserScriptLoader();
    var moduleManager = new ModuleManager(scriptLoader);

    // Provide access to the module manager for test automation
    global.__moduleManager = moduleManager;

    function define(id, dependencies, callback) {
        if (typeof id !== 'string') {
            callback = dependencies;
            dependencies = id;
            id = null;
        }
        if (typeof dependencies !== 'object' || !(dependencies instanceof Array)) {
            callback = dependencies;
            dependencies = null;
        }
        if (!dependencies) {
            dependencies = [];
        }
        // Special case for jQuery which always registers itself with 'jquery'
        if (!!id && id !== 'jquery') {
            moduleManager.enqueueDefineModule(id, dependencies, callback);
        } else {
            moduleManager.enqueueDefineAnonymousModule(dependencies, callback);
        }
    }

    function configure(params, shouldOverwrite) {
        if (shouldOverwrite) {
            moduleManager.setConfig(new Configuration(params));
        } else {
            var currentConfig = moduleManager.getConfig();
            moduleManager.setConfig(currentConfig.cloneAndMerge(params));
        }
    }

    function require() {
		//alert(arguments.length);
        if (arguments.length === 1) {
            if ((arguments[0] instanceof Object) && !(arguments[0] instanceof Array)) {
                configure(arguments[0]);
                return;
            }
            if (typeof arguments[0] === 'string') {
                return moduleManager.synchronousRequire(arguments[0]);
            }
        }
        if (arguments.length === 2) {
            if (arguments[0] instanceof Array) {
                moduleManager.defineModule(anonymousModuleGenerator(), arguments[0], arguments[1]);
                return;
            }
        }
        throw new Error('Unrecognized require call');
    }
    require.config = configure;

    if (!isWebWorker) {
        window.onload = function () {
            var i, len, script, main, scripts = document.getElementsByTagName('script');

            // Look through all the scripts for the data-main attribute
            for (i = 0, len = scripts.length; i < len; i++) {
                script = scripts[i];
                main = script.getAttribute('data-main');
                if (main) {
                    break;
                }
            }

            // Load the main script
            if (main) {
                moduleManager.defineModule(anonymousModuleGenerator(), [main], null, new ModuleIdResolver(new Configuration(), ''));
            }
        };
    }

    define.amd = {
        jQuery: true
    };
    global.define = define;

    // The global variable require can configure the loader
    if (typeof global.require !== 'undefined' && Object.prototype.toString.call(global.require) !== '[object Function]') {
        require.config(global.require);
    }
    global.require = require;

})(this);


// SIG // Begin signature block
// SIG // MIIa5gYJKoZIhvcNAQcCoIIa1zCCGtMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFIwKcoNi8ggL
// SIG // k4wNF2YF5327apZcoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABvZS1YbQcRRigAAAAAAG8wDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwMloXDTE2MDYyMDE3MzIwMlowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAM/mbc3BKs2uqF7YlU8tA0NHczu4QtLQV5rd9lM2
// SIG // d9WIRSRqyKvQZumLxaoPnvKDRrYqydg2xvSg/xFvZvBe
// SIG // FBmysWf48V6UhqqOJa/4NRP9gi/HOF5TwHYcxdN5O7Bj
// SIG // 60+TmgXwohdx3MYMltMABS5MbVizf7QsJHB7lmksbIp4
// SIG // CW1JmY46PmaVj09/eBtge1fJUfRLbVHDNLf4OgrWEd/D
// SIG // OqUeoDjc662q+EPEg5qNlzQDNAQa761UNqTUGiz9w27w
// SIG // eOcp8blEwHG0L8QQiwz3NmJ5/QdXfeoFfEyfTjA/J1A4
// SIG // Zga7Xag+xZDb3zx2Vq2VIDRTcu1pWW7wVB9A1TkCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBTypkkpeHxXcFJiz+2s
// SIG // t3sgNEfc/TAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQCNs0y22OwN
// SIG // h4YZXuQA55e41c9MCjy991XT9PCgr1VynCOXuYIqxxYK
// SIG // xScTWdDaMCuIQrpSA+ZeySVoJyeNZKdt+beaaqs+rELQ
// SIG // HiQmzFSv9pCBax6tQ58bexBXajI2MaJEaAGYWisStIkx
// SIG // 9kwMrhU8tyQkXbv/fFNMhMQNzUZ3finKn7JGYoK0NMf1
// SIG // EmlcrXnNMe7pR474/FPz5AKQUWvO+p3jhb9ZgFkQ1Wej
// SIG // TKby5KC02ME6oWpIpojOcPapnN7zU5M9cHEA/77rfPz/
// SIG // CGMPS1FZqxUZkHQe/7u9qjWbPZ7zEBTVevYf1uJ185J0
// SIG // Da0W2RLPoZut0hLqADsjFQzPMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggTQMIIEzAIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIHpMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBRTHifItvYQ
// SIG // /HTvFaNL6OqMDVxQcDCBiAYKKwYBBAGCNwIBDDF6MHig
// SIG // XoBcAEwAbwBhAGQAZQByAF8AOQBmAGMAOQBiAGQAZQBh
// SIG // AC0AOABlADIAOAAtADQANAA3ADIALQA5ADMAZgAxAC0A
// SIG // ZgBmAGIAMgA1ADcAZQBlAGIAOQA4ADIALgBqAHOhFoAU
// SIG // aHR0cDovL21pY3Jvc29mdC5jb20wDQYJKoZIhvcNAQEB
// SIG // BQAEggEAFKc+IIVxDtDtLpamKIt5vOd7uXkUvcgT2GHV
// SIG // 5cmtr0GkYFthjgyxceGXOgm2t7v4dG/MtWZMRqW3Kpaz
// SIG // c/WT7maNFPeOpToCE0rmcjoDQD3M+dvbVSXqSe2lMHnr
// SIG // n8J0JyU1vB8IVVGR4dosJ5fYTlYqRGu5kUMkM9UL6Pi8
// SIG // 3V/OlooZ8o6Fo2DJJLjRzR8pv4KkUv3mYO5DfvCu8cAH
// SIG // TvaGPbVBqWSMEuma3DYiH+pqV4L8v4fmdM3ZfosLe0EF
// SIG // cnSh1whcD/Y5mDvotuvLiVMtGUqZ6ONHehZvEFFqJ61B
// SIG // /k7AstB7fwDUcadm2Eb+VdFMVVifgDkYk7/UErcGsqGC
// SIG // AigwggIkBgkqhkiG9w0BCQYxggIVMIICEQIBATCBjjB3
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBQQ0ECEzMAAABvZS1YbQcR
// SIG // RigAAAAAAG8wCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJ
// SIG // AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE1
// SIG // MDYyOTA0MzQyOVowIwYJKoZIhvcNAQkEMRYEFJpBaPWR
// SIG // L/2O9rv+iIUAtq1p+QKNMA0GCSqGSIb3DQEBBQUABIIB
// SIG // AMUI7Zod7l6OPgjTxE3s57lFPDXSsZGYfS2y9pA6b1nV
// SIG // efWjORyIZ/2pyEAAnzbwVE4fpDGrEOeYW0VZjQl94ZTp
// SIG // 5z4kZefvvXJ0lM8PKGbNreSRxNb4VApHRfM6A28+ZuBL
// SIG // Gbm45zDmmyV3FvGmZ4Mu07j23fAHylx8jfh2nFxTl6jG
// SIG // cn6mXVonIjjCpMjdSI+WnNs3NpfbcYmBYvp3aeyuT919
// SIG // 7Wc6WNzk/7WLzDWapraEA/NuLDWAV+YfNLvfKxny79D9
// SIG // Trol6gCr0BmNL5PoE0zzfgOP6ZmAcwGWaHt4SJoei3t7
// SIG // 802P5C8k+FIuT2b1JV8QPRTWzUEInc6NZaA=
// SIG // End signature block
